/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioResourceAssignment;
import filenet.sim.api.VWScenarioResourceType;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class VWScenarioResourceDefinition
implements Serializable,
Cloneable {
    private VWScenarioDefinition m_scenarioDef = null;
    private List m_resourceAssignments = Collections.synchronizedList(new ArrayList());
    private String m_name;
    private int m_id = -1;
    private int m_qty;
    private int m_type;
    private double m_cost;
    private float m_performance;

    protected VWScenarioResourceDefinition(String name, int type, int quantity, double cost, float performance, VWScenarioDefinition scenarioDef) throws VWException {
        this.m_scenarioDef = scenarioDef;
        this.setName(name);
        this.setType(type);
        this.setQuantity(quantity);
        this.setCost(cost);
        this.setPerformance(performance);
        this.refreshAssignmentCache();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) throws VWException {
        if (name == null) {
            throw new VWException("sim.api.VWScenarioResourceDefinition.NullResourceNameParameter", "The name parameter can not be null.");
        }
        if (name.equals(this.m_name)) {
            return;
        }
        if (this.m_scenarioDef.hasResource(name)) {
            throw new VWException("sim.api.VWScenarioResourceDefinition.ResourceAlreadyExists", "A resource with the name {0} has already been created.", name);
        }
        this.m_scenarioDef.updateResource(this.m_name, name);
        this.m_name = name;
        Iterator i = this.m_resourceAssignments.iterator();
        while (i.hasNext()) {
            ((VWScenarioResourceAssignment)i.next()).setResourceName(name);
        }
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int id) {
        this.m_id = id;
    }

    public int getQuantity() {
        return this.m_qty;
    }

    public void setQuantity(int quantity) throws VWException {
        if (quantity <= 0) {
            throw new VWException("sim.api.VWScenarioResourceDefinition.InvalidQtyParameter", "The quantity parameter must be greater than zero.");
        }
        this.m_qty = quantity;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) throws VWException {
        if (!VWScenarioResourceType.isValid(type)) {
            throw new VWException("sim.api.VWScenarioResourceDefinition.InvalidResourceType", "The type {0} is not a valid resource type.", new Integer(type));
        }
        this.m_type = type;
    }

    public double getCost() {
        return this.m_cost;
    }

    public void setCost(double cost) throws VWException {
        if (cost < 0.0) {
            throw new VWException("sim.api.VWScenarioResourceDefinition.InvalidCostParameter", "The cost parameter must be greater than or equal to zero.");
        }
        this.m_cost = cost;
    }

    public float getPerformance() {
        return this.m_performance;
    }

    public void setPerformance(float performance) throws VWException {
        if (performance <= 0.0f) {
            throw new VWException("sim.api.VWScenarioResourceDefinition.InvalidPerformanceParameter", "The performance parameter must be greater than zero.");
        }
        this.m_performance = performance;
    }

    protected void toXML(StringBuffer buffer, String baseIndent) throws VWException {
        String LEVEL_1_INDENT = baseIndent + "\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        buffer.append(baseIndent + "<Resource ");
        buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(this.getName()) + "\" ");
        buffer.append("DisplayName=\"" + VWScenarioXMLHandler.toXMLString(this.getName()) + "\" ");
        if (this.getId() != -1) {
            buffer.append("Id=\"" + this.getId() + "\" ");
        }
        buffer.append("Type=\"" + VWScenarioXMLHandler.toXMLString(VWScenarioResourceType.typeToString(this.getType())) + "\" ");
        buffer.append("Quantity=\"" + this.getQuantity() + "\" ");
        buffer.append("Cost=\"" + this.getCost() + "\" ");
        buffer.append("Performance=\"" + this.getPerformance() + "\">\n");
        if (this.hasResourceAssignments()) {
            StringBuffer roleXML = new StringBuffer(LEVEL_1_INDENT + "<RoleAssignments>\n");
            StringBuffer shiftXML = new StringBuffer(LEVEL_1_INDENT + "<ShiftAssignments>\n");
            HashMap shifts = new HashMap();
            int index = 1;
            for (VWScenarioResourceAssignment resAssignment : this.m_resourceAssignments) {
                String shiftName = resAssignment.getRole().getShift().getName();
                roleXML.append(LEVEL_2_INDENT + "<RoleAssignment ");
                roleXML.append("Role=\"" + VWScenarioXMLHandler.toXMLString(resAssignment.getRole().getRoleName()) + "\" ");
                roleXML.append("Index=\"" + index + "\" ");
                roleXML.append("Shift=\"" + VWScenarioXMLHandler.toXMLString(shiftName) + "\" ");
                roleXML.append("Performance=\"" + resAssignment.getPerformance() + "\"/>\n");
                if (!shifts.containsKey(shiftName)) {
                    shifts.put(shiftName, null);
                    shiftXML.append(LEVEL_2_INDENT + "<ShiftAssignment Shift=\"" + VWScenarioXMLHandler.toXMLString(shiftName) + "\"/>\n");
                }
                ++index;
            }
            roleXML.append(LEVEL_1_INDENT + "</RoleAssignments>\n");
            shiftXML.append(LEVEL_1_INDENT + "</ShiftAssignments>\n");
            buffer.append(roleXML.toString());
            buffer.append(shiftXML.toString());
        }
        buffer.append(baseIndent + "</Resource>\n");
    }

    public void validate(Vector EDefVector) throws VWException {
        VWScenarioValidationError theError;
        VWString theMessage;
        if (this.m_cost < 0.0) {
            theMessage = new VWString("sim.api.VWResourceDefinition.InvalidResourceCost", "Invalid resource cost: {0}. Resource cost can not be a negative value.", Double.toString(this.m_cost));
            theError = new VWScenarioValidationError(3, 1, this.getName(), null, theMessage.toString());
            EDefVector.addElement(theError);
        }
        if (this.m_qty < 0) {
            theMessage = new VWString("sim.api.VWResourceDefinition.InvalidResourceQty", "Invalid resource quantity: {0}. Resource quantity can not be a negative value.", Integer.toString(this.m_qty));
            theError = new VWScenarioValidationError(3, 1, this.getName(), null, theMessage.toString());
            EDefVector.addElement(theError);
        }
    }

    public String toString() {
        return this.getName();
    }

    protected VWScenarioDefinition getScenario() {
        return this.m_scenarioDef;
    }

    protected boolean hasResourceAssignments() {
        return this.m_resourceAssignments.size() > 0;
    }

    protected boolean isAssignedToShift(String shiftName) {
        Iterator i = this.m_resourceAssignments.iterator();
        while (i.hasNext()) {
            if (!((VWScenarioResourceAssignment)i.next()).getRole().getShift().getName().equals(shiftName)) continue;
            return true;
        }
        return false;
    }

    public VWScenarioResourceAssignment[] getResourceAssignments() {
        if (this.m_resourceAssignments.size() == 0) {
            return null;
        }
        return this.m_resourceAssignments.toArray(new VWScenarioResourceAssignment[0]);
    }

    protected void addResourceAssignmentToCache(VWScenarioResourceAssignment rAssignment) {
        if (!this.m_resourceAssignments.contains(rAssignment)) {
            this.m_resourceAssignments.add(rAssignment);
        }
    }

    protected void removeResourceAssignmentFromCache(VWScenarioResourceAssignment rAssignment) {
        this.m_resourceAssignments.remove(rAssignment);
    }

    private void refreshAssignmentCache() throws VWException {
        this.m_resourceAssignments.clear();
        VWScenarioShiftDefinition[] shifts = this.getScenario().getShifts();
        if (shifts != null) {
            for (int i = 0; i < shifts.length; ++i) {
                VWScenarioRoleAssignment[] roles = shifts[i].getRoleAssignments();
                if (roles == null) continue;
                for (int j = 0; j < roles.length; ++j) {
                    if (!roles[j].hasResource(this.getName())) continue;
                    this.addResourceAssignmentToCache(roles[j].getResourceAssignment(this.getName()));
                }
            }
        }
    }

    protected Object clone(String resourceName) {
        VWScenarioResourceDefinition clone = null;
        try {
            clone = (VWScenarioResourceDefinition)super.clone();
            clone.m_name = resourceName;
            clone.m_resourceAssignments = Collections.synchronizedList(new ArrayList());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

